/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import com.Da_Technomancer.essentials.tileentities.SortingHopperTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SortingHopper
extends BaseEntityBlock
implements IReadable {
    public static final DirectionProperty FACING = HopperBlock.f_54021_;
    public static final BooleanProperty ENABLED = HopperBlock.f_54022_;
    private static final VoxelShape INPUT_SHAPE = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.m_83110_((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape BASE = Shapes.m_83113_((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)Hopper.f_59296_, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = Hopper.f_59296_;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    protected SortingHopper(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected SortingHopper() {
        this(ESBlocks.getMetalProperty());
        String name = "sorting_hopper";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return BASE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return Hopper.f_59296_;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction enumfacing = context.m_43719_().m_122424_();
        if (enumfacing == Direction.UP) {
            enumfacing = Direction.DOWN;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)enumfacing)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(!context.m_43725_().m_46753_(context.m_8083_())));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SortingHopperTileEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (ESConfig.isWrench(playerIn.m_21120_(hand))) {
                worldIn.m_46597_(pos, (BlockState)state.m_61122_((Property)FACING));
                if (te instanceof SortingHopperTileEntity) {
                    ((SortingHopperTileEntity)te).resetCache();
                }
                return InteractionResult.SUCCESS;
            }
            if (te instanceof SortingHopperTileEntity) {
                playerIn.m_5893_((MenuProvider)((SortingHopperTileEntity)te));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        boolean block;
        boolean bl = block = !worldIn.m_46753_(pos);
        if (block != (Boolean)state.m_61143_((Property)ENABLED)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(block)), 4);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (te instanceof SortingHopperTileEntity) {
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((SortingHopperTileEntity)te));
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    @Override
    public float read(Level world, BlockPos pos, BlockState state) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof Container) {
            Container inv = (Container)te;
            float f = 0.0f;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack.m_41619_()) continue;
                f += (float)stack.m_41613_() / (float)Math.min(64, stack.m_41741_());
            }
            f /= (float)inv.m_6643_();
            return f *= 15.0f;
        }
        return 0.0f;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)new TranslatableComponent("tt.essentials.sorting_hopper.desc"));
        tooltip.add((Component)new TranslatableComponent("tt.essentials.sorting_hopper.quip").m_6270_(ESConfig.TT_QUIP));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return ITickableTileEntity.createTicker(type, SortingHopperTileEntity.TYPE);
    }
}

